@echo off

REM ------------------------------------------------------------
REM Detect the folder this script is in
REM ------------------------------------------------------------
REM %~dp0  = drive + path of the running .bat, with trailing \
set "SCRIPT_DIR=%~dp0"

REM Normalize: remove trailing backslash if present
if "%SCRIPT_DIR:~-1%"=="\" set "SCRIPT_DIR=%SCRIPT_DIR:~0,-1%"

echo Detected script folder:
echo   "%SCRIPT_DIR%"
echo.

REM ------------------------------------------------------------
REM 1a) Check required files exist under worldly_organizer
REM ------------------------------------------------------------
set "CODEBASE_DIR=%SCRIPT_DIR%\worldly_organizer"
set "FILE1=%CODEBASE_DIR%\worg_proc.py"
REM set "FILE2=%CODEBASE_DIR%\ui_manager.py"

set "ERROR_REASON="

if not exist "%FILE1%" (
  set "ERROR_REASON=Required file not found: %FILE1%"
  goto :fail
)

REM if not exist "%FILE2%" (
REM   set "ERROR_REASON=Required file not found: %FILE2%"
REM   goto :fail
REM )

echo codebase detected

REM ------------------------------------------------------------
REM 1b) Check that SCRIPT_DIR is under %LOCALAPPDATA% or %USERPROFILE%\Documents
REM ------------------------------------------------------------

REM Clean, simple prefix check using FINDSTR (case-insensitive)

echo.%SCRIPT_DIR%| findstr /I /B /C:"%LOCALAPPDATA%" >nul && set "IS_UNDER_ALLOWED=1"
echo.%SCRIPT_DIR%| findstr /I /B /C:"%USERPROFILE%\Documents" >nul && set "IS_UNDER_ALLOWED=1"

if not "%IS_UNDER_ALLOWED%"=="1" (
  set "ERROR_REASON=Script folder is not under %%LOCALAPPDATA%% or %%USERPROFILE%%\Documents."
  goto :fail
)

echo codebase in appropriate location



REM ------------------------------------------------------------
REM 2) All checks passed: set WORG_HOME permanently
REM     WORG_HOME should be the script folder (which contains worldly_organizer)
REM ------------------------------------------------------------
set "WORG_HOME=%SCRIPT_DIR%\worldly_organizer"
echo All checks passed.
echo Setting user environment variable:
echo   WORG_HOME="%WORG_HOME%"
echo.

REM Persist for current user (no admin needed)
setx WORG_HOME "%WORG_HOME%" >nul
if errorlevel 1 (
  set "ERROR_REASON=Failed to set user environment variable WORG_HOME."
  goto :fail
)

echo WORG_HOME has been set sucx1cessfully.
echo.

REM 3) Run the installer logic via PowerShell, but user runs only this .bat.
REM (No policy changes; bypass is process-only.)
powershell.exe -NoProfile -ExecutionPolicy Bypass -Command ^
  "& { $ErrorActionPreference='Stop'; $env:WORG_HOME='%WORG_HOME%'; . '%~dp0user-worg-install.ps1' }"


REM ------------------------------------------------------------
REM 4) Failure reporting
REM ------------------------------------------------------------
:fail
echo.
echo Error reason %ERROR_REASON%
if not "%ERROR_REASON%"=="" (
  echo Installation checks failed.
  echo Reason:
  echo   %ERROR_REASON%
  echo.
  echo To fix this before re-running:
  echo   1) Make sure you unzip the installation in a folder under:
  echo        %LOCALAPPDATA%   or   %USERPROFILE%\Documents
  echo   2) Ensure that folder contains a subfolder "worldly_organizer"
  echo      with both:
  echo        worldly_organizer\worg_proc.py
  echo        worldly_organizer\ui_manager.py
  echo   3) Then re-run this batch script.
  echo.
)

pause
goto :eof

set "%~3=%OUT%"
goto :eof
