@echo off
setlocal ENABLEDELAYEDEXPANSION

REM ==========================
REM 1. Confirm WORG_HOME
REM ==========================
if not defined WORG_HOME (
    echo [ERROR] WORG_HOME environment variable is not set.
    echo Set WORG_HOME to your project folder, then re-run this script.
    pause
    exit /b 1
)

if not exist "%WORG_HOME%\" (
    echo [ERROR] WORG_HOME does not point to an existing folder.
    pause
    exit /b 1
)

if not exist "%WORG_HOME%\worg_proc.py" (
    echo [ERROR] worg_proc.py not found in "%WORG_HOME%".
    pause
    exit /b 1
)

if not exist "%WORG_HOME%\.venv\Scripts\activate.bat" (
    echo [ERROR] .venv not found in "%WORG_HOME%\.venv".
    echo Run your install script to create the virtual environment first.
    pause
    exit /b 1
)

echo WORG_HOME is "%WORG_HOME%".
echo.

REM ==========================
REM 2. Start Ollama (cmd 1) only if not already running
REM ==========================
echo Checking if Ollama is already running on port 11434...
netstat -ano | findstr 11434 >nul 2>&1

if errorlevel 1 (
    echo [INFO] No listener detected on port 11434. Starting Ollama in a new window...
    start "" cmd /k "echo [INFO] Starting 'ollama run llama3.2:3b' on default port... & ollama run llama3.2:3b"
) else (
    echo [INFO] A process is already listening on port 11434. Assuming Ollama is running; not starting a new instance.
)

REM (Optional) quick port check – non-fatal if it fails
REM echo Checking if something is listening on port 11434 ...
REM netstat -ano | findstr 11434 >nul 2>&1
REM if errorlevel 1 (
REM     echo [WARN] Nothing appears to be listening on port 11434 yet. Ollama may still be starting.
REM ) else (
REM     echo [INFO] Port 11434 has a listener (likely Ollama).
REM )
REM Ollama is running


REM ==========================
REM 3. Start worg_proc (cmd 2)
REM ==========================
set "WATCH_LOG=%WORG_HOME%\worg_proc.log"
if exist "%WATCH_LOG%" del "%WATCH_LOG%"

echo Starting worg_proc.py in a new window...

start "" cmd /k "cd /d \"%WORG_HOME%\" & call .venv\Scripts\activate.bat & echo [INFO] Running worg_proc.py & python worg_proc.py"

REM ==========================
REM 4. Start UI (cmd 3)
REM ==========================
if exist "%WORG_HOME%\ui_manager.py" (
    echo Starting ui_manager.py in a new window...
    start "" cmd /k "cd /d \"%WORG_HOME%\" & call .venv\Scripts\activate.bat & echo [INFO] Running ui & python ui_manager.py"
) else (
    echo [WARN] ui_manager.py not found in "%WORG_HOME%". Skipping UI window.
)

REM ==========================
REM 5. Wait fixed time before starting UI
REM ==========================
echo Waiting 30 seconds to allow worg_proc.py to stabilize...
timeout /t 30 /nobreak >nul
echo [INFO] Wait complete. Proceeding to start UI...


REM ==========================
REM 6. Open browser
REM ==========================
echo Opening default browser to http://localhost:5000/mydocs ...
start "" "http://localhost:5000/mydocs"

echo.
echo All windows have been launched. You can close this master window.
pause
endlocal
